version = "1.7"
container_url = "lbmc/samtools:${version}"

params.sort_bam_out =""
process sort_bam {
  container = "${container_url}"
  label "big_mem_multi_cpus"
  tag "sorting"
  if (params.sort_bam_out != "") {
    publishDir "results/${params.sort_bam_out}", mode: 'copy'
  }

  input:
    path(bam)

  output:
    path("*sorted.bam"), emit: sorted_bam

  script:
"""
samtools sort -@ ${task.cpus} ${bam} -O BAM -o ${bam.simpleName}_sorted.bam
"""
}

params.start_position_counts_out = ""
process start_position_counts {
    tag "Start positions count"
    label "big_mem_multi_cpus"
    publishDir "results/${params.start_position_counts_out}", mode: 'copy'

    input:
        tuple path(bam), path(index)

    output:
        path "*", emit: count

    script:
"""
samtools view -F 260 ${bam} |
  cut -f 1,4 |
  sort > Start_positions_counts.txt
"""
}

params.index_bam_out = ""
process index_bam {
  container = "${container_url}"
  label "small_mem_mono_cpus"
  tag "indexing"
  if (params.index_bam_out != "") {
    publishDir "results/${params.index_bam_out}", mode: 'copy'
  }

  input:
    path(bam)

  output:
    path("*.bai")

  script:
"""
samtools index -@ ${task.cpus} ${bam}
"""
}

params.indexed_bam_out =""
process sort_index_bam {
  container = "${container_url}"
  label "big_mem_multi_cpus"
  tag "sorting"
  if (params.indexed_bam_out != "") {
    publishDir "results/${params.indexed_bam_out}", mode: 'copy'
  }

  input:
    path(bam)

  output:
    tuple path("*sorted.bam"), path("*.bai"), emit: indexed_bam

  script:
"""
samtools sort -@ ${task.cpus} ${bam} -o ${bam.simpleName}_sorted.bam
samtools index -@ ${task.cpus} ${bam.simpleName}_sorted.bam
"""
}