version = "0.2.4"
container_url = "xgrand/porechop:${version}"

process porechop {
    container = "${container_url}"
    label "small_mem_multi_cpus"
    tag "$file_id"
    if (params.porechop_out != "") {
      publishDir "results/${params.porechop_out}", mode: 'copy'
    }

  input:
    path(merged_fastq)

  output:
    path("*"), emit: porechoped_fastq
  script:
"""
porechop -i ${merged_fastq} -o merged_porechoped.fastq --threads ${task.cpus}
"""
}