version = "6.4.6"
container_url = "xgrand/ont-guppy:${version}"

params.basecalling_out = ""
params.flowcell = "FLO-MIN106"
params.kit = "SQK-PBK004"
params.min_qscore = 7.0
params.gpu_runners_per_device = 1
params.num_callers = 1
params.chunks_per_runner = 1
process basecall_fast5_gpu {
  container = "${container_url}"
  label "gpu"
  tag "$fast5_folder"
  if (params.basecalling_out != "") {
    publishDir "results/${params.basecalling_out}", mode: 'copy'
  }

  if (params.flowcell == "") {
      errorFlowcell << "WARNING ! No Flowcell type given..."
      errorFlowcell.view()
  }

  if (params.kit == "") {
      errorKit "WARNING ! No kit type given..."
      errorKit.view()
  }

  input:
    val(fast5_folder)

  output:
    path "pass", emit: pass
    path "fail", emit: fail
    path "sequencing_summary.txt", emit: sequencing_summary
    path "sequencing_telemetry.js", emit: sequencing_telemetry

  script:
"""
echo "Start basecalling using GPUs."
# guppy_basecaller --print_workflows
guppy_basecaller --compress_fastq \
   -i ${fast5_folder} \
   -s . \
   --flowcell ${params.flowcell} \
   --kit ${params.kit} \
   -x "cuda:all" \
   --min_qscore ${params.min_qscore} \
   --gpu_runners_per_device ${params.gpu_runners_per_device} \
   --num_callers ${params.num_callers} \
   --chunks_per_runner ${params.chunks_per_runner}
"""
}

process basecall_fast5_cpu {
  container = "${container_url}"
  label "big_mem_multi_cpus"
  tag "$fast5_folder"
  if (params.basecalling_out != "") {
    publishDir "results/${params.basecalling_out}", mode: 'copy'
  }

  if (params.flowcell == "") {
      errorFlowcell << "WARNING ! No Flowcell type given..."
      errorFlowcell.view()
  }

  if (params.kit == "") {
      errorKit "WARNING ! No kit type given..."
      errorKit.view()
  }

  input:
    val(fast5_folder)

  output:
    path "pass", emit: pass
    path "fail", emit: fail
    path "sequencing_summary.txt", emit: sequencing_summary
    path "sequencing_telemetry.js", emit: sequencing_telemetry

  script:
"""
echo "Start basecalling using CPUs."
guppy_basecaller --compress_fastq \
   -i ${fast5_folder} \
   -s . \
   --cpu_threads_per_caller ${params.cpu_threads_per_caller} \
   --num_callers ${params.num_callers} \
   --flowcell ${params.flowcell} \
   --kit ${params.kit}
"""
}