version = "1.79"
container_url = "xgrand/biopython:${version}"

process linkAdapt {
  container = "${container_url}"
  label "small_mem_mono_cpus"
  tag "$file_id"
  if (params.ref_out != "") {
    publishDir "results/${params.ref_out}", mode: 'copy'
  }

  input:
    path(fasta)
    val(adapt)

  output:
    path "res.fasta", emit: linkedTranscriptome

  script:
  """
  linkAdapt.py ${fasta} ${adapt}
  """
}