version = "5.0.11"
container_url = "xgrand/guppy-cpu:${version}"

params.basecalling_out = ""
params.flowcell = "FLO-MIN106"
params.kit = "SQK-PBK004"
params.cpu_threads_per_caller = 16
params.num_callers = 1
process basecall_fast5 {
  container = "${container_url}"
  label "big_mem_multi_cpus"
  tag "$fast5_folder"
  if (params.basecalling_out != "") {
    publishDir "results/${params.basecalling_out}", mode: 'copy'
  }

  if (params.flowcell == "") {
      errorFlowcell << "WARNING ! No Flowcell type given..."
      errorFlowcell.view()
  }

  if (params.kit == "") {
      errorKit "WARNING ! No kit type given..."
      errorKit.view()
  }

  input:
    val(fast5_folder)

  output:
    path "pass", emit: pass
    path "fail", emit: fail
    path "sequencing_summary.txt", emit: sequencing_summary
    path "sequencing_telemetry.js", emit: sequencing_telemetry

  script:
"""
echo "Start basecalling using CPUs."
guppy_basecaller --compress_fastq \
   -i ${fast5_folder} \
   -s . \
   --cpu_threads_per_caller ${params.cpu_threads_per_caller} \
   --num_callers ${params.num_callers} \
   --flowcell ${params.flowcell} \
   --kit ${params.kit}
"""
}