version = "2.8"
container_url = "xgrand/cutadapt:${version}"

process cut_5pRACE {
  container = "${container_url}"
  label "small_mem_mono_cpus"
  tag "cutadapt"
  
  if (params.cutadapt_out != "") {
    publishDir "results/${params.cutadapt_out}", mode: 'copy'
  }

  input:
  path(fastq)
  val(adapt)

  output:
  path("*_cut_*"), emit: fastq_cutadapt

  """
  cutadapt -e 0.2 -g ${adapt} \
   --revcomp \
   -o "merged_porechoped_cut_fastq.fastq" \
   ${fastq}
  """
}