version = "3.15.4"
container_url = "xgrand/alpine:${version}"


params.fastq_out = ""
process concatenate {
    tag "fastq_folder"
    label "big_mem_mono_cpus"

    if (params.fastq_out != "") {
        publishDir "results/${params.fastq_out}", mode: 'copy'
    }

    input:
        path fastq

    output:
        path "merged.fastq.gz", emit: merged_fastq

    script:
"""
zcat ${fastq}/*.fastq.gz > merged.fastq
gzip --quiet merged.fastq
"""
}